package kom.itbeankit.common.itbeanframe;


/**
The CheckboxMenuItemGroup class is used to group together a set of CheckboxMenuItems.
Exactly one check box button in a CheckboxMenuItemGroup can be in the "on" state at any given time. Pushing any
button sets its state to "on" and forces any other button that is in the "on" state into the "off" state.
<p>
The following code example produces a new check box menu item group in a menu named Level, with three check box menu items:
<p>
<code>
   CheckboxMenuItemGroup cbg = new CheckboxMenuItemGroup();<br>
   Menu aMenu = new Menu("Level");<br>
   CheckboxMenuItem level1 = new CheckboxMenuItem("Level 1");<br>
   CheckboxMenuItem level2 = new CheckboxMenuItem("Level 2");<br>
   CheckboxMenuItem level3 = new CheckboxMenuItem("Level 3");<br>
   aMenu.add(level1);<br>
   aMenu.add(level2);<br>
   aMenu.add(level3);<br>
   cbg.add(level1);<br>
   cbg.add(level2);<br>
   cbg.add(level3);<br>
</code><p>
@author Christian C. Hoffmann
@version 0.9 1998/06/28
*/

import java.awt.*;
import java.util.*;

public class CheckboxMenuItemGroup implements java.awt.event.ItemListener, java.io.Serializable {

    private Vector items;
    private CheckboxMenuItem selectedItem;

    /**
    Constructor creates a new CheckboxMenuItemGroup
    */
    public CheckboxMenuItemGroup() {
        super();
        this.items = new Vector();
    }

    /**
    This method adds a CheckboxMenuItem to the group.
    @param item the item to add
    */
    public synchronized void add(CheckboxMenuItem item) {
        if (this.items.isEmpty()) {
            item.setState(true);
            this.selectedItem = item;
        }
        else item.setState(false);
        this.items.addElement(item);
        item.addItemListener(this);
    }

    /**
    This method will be called if an item state was changed.
    @param e the ItemEvent
    */
    public void itemStateChanged(java.awt.event.ItemEvent e) {
        CheckboxMenuItem item = (CheckboxMenuItem)e.getSource();
        if (!item.getState()) item.setState(true);
        else {
            this.selectedItem.setState(false);
            item.setState(true);
            this.selectedItem = item;
        }
    }

    /**
    This method returns the selected CheckboxMenuItem.
    @return the selected item
    */
    public CheckboxMenuItem getSelectedItem() {
        return this.selectedItem;
    }
}
